set echo ON;
spool /datos/p06b/log/salida_20170928.log;

ALTER TABLE P06B20T00_CORREDORES ADD (
P06B20_ULTEJERINCORPORADO NUMBER(4),
P06B20_ATENCPETICINCORPORADA NUMBER(7));

CREATE TABLE P06B64T00_ATENDERPETICION (
	P06B64_AP_CORRELATENCPETIC        NUMBER(7) NOT NULL,
	P06B64_AP_FECHA					DATE,
	P06B64_AP_MENSAJE				CLOB,
	P06B64_AP_IDSOL_TRAMITAGUNE		VARCHAR2(20),
	P06B64_AP_FINALIZADA			NUMBER(1) DEFAULT 0 NOT NULL,
	P06B64_AP_MENSAJEERROR			CLOB
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B64S00 FOR P06B64T00_ATENDERPETICION;

ALTER TABLE P06B64T00_ATENDERPETICION ADD CONSTRAINT P06B64I00 PRIMARY KEY
	(P06B64_AP_CORRELATENCPETIC) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B64T00_ATENDERPETICION TO P06A;
GRANT SELECT ON P06B64T00_ATENDERPETICION TO P06;

CREATE SEQUENCE P06B64SEQ00
START WITH 1
INCREMENT BY 1
MAXVALUE 9999999
NOCYCLE;

COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_FECHA IS 'Fecha de atencin de peticin';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_MENSAJE IS 'Mensaje textual recibido por el MDB';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_IDSOL_TRAMITAGUNE IS 'Identificador de solicitud de Tramitagune';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_FINALIZADA IS 'Estado de finalizacin (1-Finalizada,0-No finalizada)';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_MENSAJEERROR IS 'Mensaje de error para las atenciones de peticin no finalizadas';




CREATE TABLE P06B70T00_CORREDORES (
	P06B70_CO_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B70_CO_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B70_CO_CLASE					VARCHAR2(2) NOT NULL,
	P06B70_CO_IDENTIFICADOR			VARCHAR2(9) NOT NULL,
	P06B70_CO_RAZSOC				VARCHAR2(150),
	P06B70_CO_NOMBRE				VARCHAR2(50),
	P06B70_CO_APE1					VARCHAR2(50),
	P06B70_CO_APE2					VARCHAR2(50),
	P06B70_CO_DOMICI				VARCHAR2(50),
	P06B70_CO_CODMUN				NUMBER(4,0),
	P06B70_CO_CODPRO				NUMBER(2,0),
	P06B70_CO_CODPST				VARCHAR2(5),
	P06B70_CO_TELEFONO				VARCHAR2(9),
	P06B70_CO_MAIL					VARCHAR2(50),
	P06B70_CO_WEB					VARCHAR2(250),
	P06B70_CO_CAPSOC				NUMBER(13,2),
	P06B70_CO_PATICIPA				NUMBER(9,0)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B70S00 FOR P06B70T00_CORREDORES;

ALTER TABLE P06B70T00_CORREDORES ADD CONSTRAINT P06B70I00 PRIMARY KEY
	(P06B70_CO_CORRELATENCPETIC) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B70T00_CORREDORES TO P06A;
GRANT SELECT ON P06B70T00_CORREDORES TO P06;

COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_CLASE IS 'Clase de expediente';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_IDENTIFICADOR IS 'Identificador titular del expediente';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_RAZSOC IS 'Razn Social';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_NOMBRE IS 'Nombre';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_APE1 IS 'Apellido 1';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_APE2 IS 'Apellido 2';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_DOMICI IS 'Domicilio';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_CODMUN IS 'Cdigo de municipio';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_CODPRO IS 'Cdigo de provincia';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_CODPST IS 'Cdigo postal';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_TELEFONO IS 'Telfono';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_MAIL IS 'E-mail';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_WEB IS 'Web';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_CAPSOC IS 'Capital Social';
COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_PATICIPA IS 'Participacin';





CREATE TABLE P06B76T00_ATENCLIENTE (
	P06B76_AC_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B76_AC_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B76_AC_IDENTIFICADOR			VARCHAR2(9) NOT NULL,
	P06B76_AC_RAZSOC				VARCHAR2(150),
	P06B76_AC_NOMBRE				VARCHAR2(50),
	P06B76_AC_APE1					VARCHAR2(50),
	P06B76_AC_APE2					VARCHAR2(50)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B76S00 FOR P06B76T00_ATENCLIENTE;

ALTER TABLE P06B76T00_ATENCLIENTE ADD CONSTRAINT P06B76I00 PRIMARY KEY
	(P06B76_AC_CORRELATENCPETIC) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B76T00_ATENCLIENTE TO P06A;
GRANT SELECT ON P06B76T00_ATENCLIENTE TO P06;

COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_IDENTIFICADOR IS 'Identificador titular del expediente';
COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_RAZSOC IS 'Razn Social';
COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_NOMBRE IS 'Nombre';
COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_APE1 IS 'Apellido 1';
COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_APE2 IS 'Apellido 2';





CREATE TABLE P06B79T00_DEFECLIENTE (
	P06B79_DC_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B79_DC_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B79_DC_IDENTIFICADOR			VARCHAR2(9) NOT NULL,
	P06B79_DC_TIPO					VARCHAR2(1) NOT NULL,
	P06B79_DC_RAZSOC				VARCHAR2(150),
	P06B79_DC_NOMBRE				VARCHAR2(50),
	P06B79_DC_APE1					VARCHAR2(50),
	P06B79_DC_APE2					VARCHAR2(50)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B79S00 FOR P06B79T00_DEFECLIENTE;

ALTER TABLE P06B79T00_DEFECLIENTE ADD CONSTRAINT P06B79I00 PRIMARY KEY
	(P06B79_DC_CORRELATENCPETIC) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B79T00_DEFECLIENTE TO P06A;
GRANT SELECT ON P06B79T00_DEFECLIENTE TO P06;

COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_IDENTIFICADOR IS 'Identificador titular del expediente';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_TIPO IS 'Tipo persona: Juridica(J), Fsica(F), Indeterminada(?)';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_RAZSOC IS 'Razn Social';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_NOMBRE IS 'Nombre';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_APE1 IS 'Apellido 1';
COMMENT ON COLUMN P06B79T00_DEFECLIENTE.P06B79_DC_APE2 IS 'Apellido 2';





CREATE TABLE P06B72T00_SOCIOSEXP (
	P06B72_SC_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B72_SC_TIPO					NUMBER(2) NOT NULL,
	P06B72_SC_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B72_SC_IDENTIFICADOR			VARCHAR2(9) NOT NULL,
	P06B72_SC_TIPO1					VARCHAR2(1) NOT NULL,
	P06B72_SC_RAZSOC				VARCHAR2(150),
	P06B72_SC_NOMBRE				VARCHAR2(50),
	P06B72_SC_APE1					VARCHAR2(50),
	P06B72_SC_APE2					VARCHAR2(50),
	P06B72_SC_FECALTA				DATE,
	P06B72_SC_PARTICIPA				NUMBER(5,2),
	P06B72_SC_IDREP					VARCHAR2(9),
	P06B72_SC_NOMREP				VARCHAR2(100)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B72S00 FOR P06B72T00_SOCIOSEXP;

ALTER TABLE P06B72T00_SOCIOSEXP ADD CONSTRAINT P06B72I00 PRIMARY KEY
	(P06B72_SC_CORRELATENCPETIC,P06B72_SC_IDENTIFICADOR) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B72T00_SOCIOSEXP TO P06A;
GRANT SELECT ON P06B72T00_SOCIOSEXP TO P06;

COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_TIPO IS 'Tipo: Directos(1), Indirectos(2), Auxiliares Externos(3)';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_IDENTIFICADOR IS 'Identificador titular del expediente';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_TIPO1 IS 'Tipo persona: Juridica(J), Fsica(F), Indeterminada(?)';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_RAZSOC IS 'Razn Social';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_NOMBRE IS 'Nombre';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_APE1 IS 'Apellido 1';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_APE2 IS 'Apellido 2';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_FECALTA IS 'Fecha alta';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_PARTICIPA IS 'Porcentaje de participacin';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_IDREP IS 'Identificador representante';
COMMENT ON COLUMN P06B72T00_SOCIOSEXP.P06B72_SC_NOMREP IS 'Nombre representante';





CREATE TABLE P06B74T00_ORGANOSDIREXP (
	P06B74_OD_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B74_OD_TIPO					NUMBER(2) NOT NULL,
	P06B74_OD_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B74_OD_IDENTIFICADOR			VARCHAR2(9) NOT NULL,
	P06B74_OD_TIPO1					VARCHAR2(1) NOT NULL,
	P06B74_OD_NOMBRE				VARCHAR2(150),
	P06B74_OD_FECHNOM				DATE,
	P06B74_OD_IDCARGO				NUMBER(2),
	P06B74_OD_IDCURSO				VARCHAR2(2),
	P06B74_OD_DENCURSO				VARCHAR2(250),
	P06B74_OD_IDREP					VARCHAR2(9),
	P06B74_OD_NOMREP				VARCHAR2(100)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B74S00 FOR P06B74T00_ORGANOSDIREXP;

ALTER TABLE P06B74T00_ORGANOSDIREXP ADD CONSTRAINT P06B74I00 PRIMARY KEY
	(P06B74_OD_CORRELATENCPETIC,P06B74_OD_TIPO,P06B74_OD_IDENTIFICADOR) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B74T00_ORGANOSDIREXP TO P06A;
GRANT SELECT ON P06B74T00_ORGANOSDIREXP TO P06;

COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_TIPO IS 'Tipo: Directos(1), Indirectos(2), Auxiliares Externos(3)';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_IDENTIFICADOR IS 'Identificador titular del expediente';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_TIPO1 IS 'Tipo persona: Juridica(J), Fsica(F), Indeterminada(?)';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_NOMBRE IS 'Nombre';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_FECHNOM IS 'Fecha nombramiento';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_IDCARGO IS 'Identificador de cargo';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_IDCURSO IS 'Identificador de curso';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_DENCURSO IS 'Denominacin de curso';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_IDREP IS 'Identificador representante';
COMMENT ON COLUMN P06B74T00_ORGANOSDIREXP.P06B74_OD_NOMREP IS 'Nombre representante';





CREATE TABLE P06B80T00_CAPACIDADFINANCIERA (
	P06B80_CF_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B80_CF_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B80_CF_DECLARO				NUMBER(1,0) NOT NULL,
	P06B80_CF_IMPFONDOS				NUMBER(13,2),
	P06B80_CF_IMPCAPACIDAD			NUMBER(13,2),
	P06B80_CF_CONTRATASEGURO		NUMBER(1,0),
	P06B80_CF_TEXTOSEGURO			VARCHAR2(100),
	P06B80_CF_CONTRATAAVAL			NUMBER(1,0),
	P06B80_CF_TEXTOAVAL				VARCHAR2(100)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B80S00 FOR P06B80T00_CAPACIDADFINANCIERA;

ALTER TABLE P06B80T00_CAPACIDADFINANCIERA ADD CONSTRAINT P06B80I00 PRIMARY KEY
	(P06B80_CF_CORRELATENCPETIC) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B80T00_CAPACIDADFINANCIERA TO P06A;
GRANT SELECT ON P06B80T00_CAPACIDADFINANCIERA TO P06;

COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_DECLARO IS 'Tipo capacidad financiera declarada: Debe cumplimentar(1), Contrato (2), Cobertura inmediata(3)';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_IMPFONDOS IS 'Importe total de los fondos percibidos';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_IMPCAPACIDAD IS 'Importe de la capacidad financiera. Mayor entre 18.760 (cifra marcada por la Resolucin de 23 de Septiembre de 2008, de la Direccin General de Seguros y Fondos de Pensiones) y el 4% de los fondos percibidos';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_CONTRATASEGURO IS 'Contrata seguro';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_TEXTOSEGURO IS 'Texto seguro';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_CONTRATAAVAL IS 'Contrata aval';
COMMENT ON COLUMN P06B80T00_CAPACIDADFINANCIERA.P06B80_CF_TEXTOAVAL IS 'Texto aval';





CREATE TABLE P06B71T00_ENT_VINCULADAS (
	P06B71_EV_CORRELATENCPETIC		NUMBER(7) NOT NULL,
	P06B71_EV_NUMEXP         		VARCHAR2(15) NOT NULL,
	P06B71_EV_CIF					VARCHAR2(9) NOT NULL,
	P06B71_EV_ENTIDAD				VARCHAR2(150) NOT NULL,
	P06B71_EV_CLAVECAT				VARCHAR2(5) NOT NULL,
	P06B71_EV_ALTABAJA				NUMBER(1) DEFAULT 1 NOT NULL
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B71S00 FOR P06B71T00_ENT_VINCULADAS;

ALTER TABLE P06B71T00_ENT_VINCULADAS ADD CONSTRAINT P06B71I00 PRIMARY KEY
	(P06B71_EV_CORRELATENCPETIC,P06B71_EV_CIF) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B71T00_ENT_VINCULADAS TO P06A;
GRANT SELECT ON P06B71T00_ENT_VINCULADAS TO P06;

COMMENT ON COLUMN P06B71T00_ENT_VINCULADAS.P06B71_EV_CORRELATENCPETIC IS 'Correlativo por cada atencin de peticin';
COMMENT ON COLUMN P06B71T00_ENT_VINCULADAS.P06B71_EV_NUMEXP IS 'Nmero de expediente';
COMMENT ON COLUMN P06B71T00_ENT_VINCULADAS.P06B71_EV_CIF IS 'CIF';
COMMENT ON COLUMN P06B71T00_ENT_VINCULADAS.P06B71_EV_ENTIDAD IS 'Descripcin de la entidad';
COMMENT ON COLUMN P06B71T00_ENT_VINCULADAS.P06B71_EV_CLAVECAT IS 'Clave DGS de la entidad segn https://www.dgsfp.mineco.es/sector/EntidadesAseguradoras.asp';
COMMENT ON COLUMN P06B71T00_ENT_VINCULADAS.P06B71_EV_ALTABAJA IS 'Alta/Baja 1.-Asegurar vinculada, 2.-Asegurar no vinculada';

UPDATE P06B24T00_ORGANOSDIREXP C
SET C.P06B24_TIPO = C.P06B24_TIPO + 10
WHERE (C.P06B24_NUMEXP, C.P06B24_IDENTIFICADOR, C.P06B24_IDCARGO, C.P06B24_TIPO) IN 
(
SELECT P06B24_NUMEXP, P06B24_IDENTIFICADOR, P06B24_IDCARGO, P06B24_TIPO FROM P06B24T00_ORGANOSDIREXP B,
(SELECT P06B24_NUMEXP AS NUMEXP, P06B24_IDENTIFICADOR AS IDEN, P06B24_IDCARGO AS CARGO, MIN(A.P06B24_TIPO) AS MINIMO
FROM P06B24T00_ORGANOSDIREXP A
WHERE A.P06B24_TIPO IN (1,2,3)
GROUP BY A.P06B24_NUMEXP, A.P06B24_IDENTIFICADOR, A.P06B24_IDCARGO
HAVING COUNT(*) > 1
ORDER BY 1)
WHERE B.P06B24_NUMEXP = NUMEXP AND
      B.P06B24_IDENTIFICADOR = IDEN AND
      B.P06B24_IDCARGO = CARGO AND
      B.P06B24_TIPO > MINIMO AND
      B.P06B24_TIPO IN (1,2,3)
);

UPDATE P06B24T00_ORGANOSDIREXP
SET P06B24_TIPO = 1
WHERE P06B24_TIPO IN (2,3);

ALTER TABLE P06B24T00_ORGANOSDIREXP DROP (
P06B24_DENCARGO,
P06B24_IDREP,
P06B24_NOMREP,
P06B24_TIPO1,
P06B24_RAZSOC);

ALTER TABLE P06B74T00_ORGANOSDIREXP DROP (
	P06B74_OD_TIPO1,
	P06B74_OD_IDREP,
	P06B74_OD_NOMREP
);

ALTER TABLE P06B76T00_ATENCLIENTE ADD(
	P06B76_AC_TIPO					VARCHAR2(1) NOT NULL
);

COMMENT ON COLUMN P06B76T00_ATENCLIENTE.P06B76_AC_TIPO IS 'Tipo persona: Juridica(J), Fsica(F), Indeterminada(?)';

ALTER TABLE P06B64T00_ATENDERPETICION ADD(
	P06B64_AP_REGISTRYNUMBER					VARCHAR2(20)
);

ALTER TABLE P06B64T00_ATENDERPETICION ADD(
	P06B64_AP_ACTDOMSOC NUMBER(1),
	P06B64_AP_ACTCAPSOC NUMBER(1),
	P06B64_AP_ACTADM NUMBER(1),
	P06B64_AP_ACTORGDIR NUMBER(1),
	P06B64_AP_ACTATENCDEFCLIEN NUMBER(1),
	P06B64_AP_ACTCAPFINAN NUMBER(1),
	P06B64_AP_ACTENTVINC NUMBER(1)
);


CREATE TABLE P06B60T00_CAPACIDADFINANCIERA (
	P06B60_CF_NUMEXP         VARCHAR2(15) NOT NULL,
	P06B60_CF_DECLARO        NUMBER(4) NOT NULL,
	P06B60_CF_IMPFONDOS      NUMBER(13,2),
	P06B60_CF_IMPCAPACIDAD   NUMBER(13,2),
	P06B60_CF_CONTRATASEGURO NUMBER(1),
	P06B60_CF_TEXTOSEGURO    VARCHAR2(100),
	P06B60_CF_CONTRATAAVAL   NUMBER(1),
	P06B60_CF_TEXTOAVAL      VARCHAR2(100))
TABLESPACE P0601E00;

CREATE SYNONYM P06B60S00 FOR P06B60T00_CAPACIDADFINANCIERA;

ALTER TABLE P06B60T00_CAPACIDADFINANCIERA ADD CONSTRAINT P06B60I00 PRIMARY KEY
	(P06B60_CF_NUMEXP) USING INDEX TABLESPACE P0602E00;

GRANT SELECT ON P06B60T00_CAPACIDADFINANCIERA TO P06A;
GRANT SELECT ON P06B60T00_CAPACIDADFINANCIERA TO P06;	

ALTER TABLE P06B64T00_ATENDERPETICION ADD(
	P06B64_AP_ESTADO NUMBER(1) DEFAULT 1,
	P06B64_AP_PROCEDIMIENTO VARCHAR2(10)
);

COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_ESTADO IS 'Estado atencion peticion: Recogida(1), Aprobada(2), Rechazada(3)';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_PROCEDIMIENTO IS 'Procedimiento: Alta, Modificacion y Cancelacion (Valores definidos en properties)';


ALTER TABLE P06B20T00_CORREDORES ADD (
P06B20_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '5' NOT NULL);

UPDATE P06B20T00_CORREDORES SET
P06B20_TIPOATENCIONCLIENTE = '3'
WHERE P06B20_NUMEXP IN
(select distinct P06B20_NUMEXP from P06B20T00_CORREDORES, P06B26T00_ATENCLIENTE
where P06B20_NUMEXP =  P06B26_NUMEXP
union
select distinct P06B20_NUMEXP from P06B20T00_CORREDORES, P06B29T00_DEFECLIENTE
where P06B20_NUMEXP =  P06B29_NUMEXP);

COMMENT ON COLUMN P06B20T00_CORREDORES.P06B20_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: No procede(4), Pendiente informar(5), Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';



ALTER TABLE P06B70T00_CORREDORES ADD (
P06B70_CO_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '5');

COMMENT ON COLUMN P06B70T00_CORREDORES.P06B70_CO_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: No procede(4), Pendiente informar(5), Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';



ALTER TABLE P06B26T00_ATENCLIENTE ADD (
P06B26_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '3');

COMMENT ON COLUMN P06B26T00_ATENCLIENTE.P06B26_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';



ALTER TABLE P06B29T00_DEFECLIENTE ADD (
P06B29_TIPOATENCIONCLIENTE VARCHAR2(1) DEFAULT '3');

COMMENT ON COLUMN P06B29T00_DEFECLIENTE.P06B29_TIPOATENCIONCLIENTE IS 'Tipo Atencin Cliente: Adherido al CV(1), Adherido al CG(2), Cuenta con servicio(3)';


Insert into P06B26T00_ATENCLIENTE (P06B26_NUMEXP,P06B26_IDENTIFICADOR,P06B26_TIPO,P06B26_CLASE,P06B26_RAZSOC,P06B26_NOMBRE,P06B26_APE1,P06B26_APE2,P06B26_DOMICI,P06B26_CODMUN,P06B26_LOCALI,P06B26_CODPRO,P06B26_CODPST,P06B26_TIPOATENCIONCLIENTE) values ('CV','99999999R','F','I',null,null,null,null,null,null,null,null,null,'1');
Insert into P06B26T00_ATENCLIENTE (P06B26_NUMEXP,P06B26_IDENTIFICADOR,P06B26_TIPO,P06B26_CLASE,P06B26_RAZSOC,P06B26_NOMBRE,P06B26_APE1,P06B26_APE2,P06B26_DOMICI,P06B26_CODMUN,P06B26_LOCALI,P06B26_CODPRO,P06B26_CODPST,P06B26_TIPOATENCIONCLIENTE) values ('CG','99999999R','F','I',null,null,null,null,null,null,null,null,null,'2');

Insert into P06B29T00_DEFECLIENTE (P06B29_NUMEXP,P06B29_IDENTIFICADOR,P06B29_TIPO,P06B29_RAZSOC,P06B29_NOMBRE,P06B29_APE1,P06B29_APE2,P06B29_DOMICI,P06B29_CODMUN,P06B29_LOCALI,P06B29_CODPRO,P06B29_CODPST,P06B29_TELEFOT,P06B29_TELEFOM,P06B29_TELEFOC,P06B29_FAX1,P06B29_FAX2,P06B29_MAIL,P06B29_WEB,P06B29_TIPOATENCIONCLIENTE) values ('CV','99999999R','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'1');
Insert into P06B29T00_DEFECLIENTE (P06B29_NUMEXP,P06B29_IDENTIFICADOR,P06B29_TIPO,P06B29_RAZSOC,P06B29_NOMBRE,P06B29_APE1,P06B29_APE2,P06B29_DOMICI,P06B29_CODMUN,P06B29_LOCALI,P06B29_CODPRO,P06B29_CODPST,P06B29_TELEFOT,P06B29_TELEFOM,P06B29_TELEFOC,P06B29_FAX1,P06B29_FAX2,P06B29_MAIL,P06B29_WEB,P06B29_TIPOATENCIONCLIENTE) values ('CG','99999999R','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'2');


ALTER TABLE P06B64T00_ATENDERPETICION ADD(
	P06B64_AP_NUMEXP VARCHAR2(15)
);

COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_NUMEXP IS 'Numero de expediente';


COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_FINALIZADA IS 'Estado de finalizacin (1-Correcto,0-Error)';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_ESTADO IS 'Estado atencion peticion: No revisable(0), Por revisar(1), Aprobada(2), Rechazada(3)';


----------------------------------------------------------------------------------------
--  Nueva tabla Codigos de ficheros adjuntados a la solicitud presentada en Tramitagune.
----------------------------------------------------------------------------------------
CREATE TABLE P06B81T00_DOCUMENTOSTRAMITAGUN
(
	P06B81_DT_NUMEXP			VARCHAR2(15) NOT NULL,
	P06B81_DT_ROLEIDPIDFICHERO	VARCHAR2(200) NOT NULL,
	P06B81_DT_CODPIDFICHERO		VARCHAR2(200) NOT NULL,
	P06B81_DT_NOMBREFICHERO		VARCHAR2(260) NOT NULL,
	P06B81_DT_EXTENSIONFICHERO  VARCHAR2(5)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B81S00 FOR P06B81T00_DOCUMENTOSTRAMITAGUN;

ALTER TABLE P06B81T00_DOCUMENTOSTRAMITAGUN ADD CONSTRAINT P06B81I00 PRIMARY KEY
	(P06B81_DT_NUMEXP, P06B81_DT_CODPIDFICHERO) USING INDEX TABLESPACE P0602E00;

ALTER TABLE P06B81T00_DOCUMENTOSTRAMITAGUN ADD CONSTRAINT FK_P06B81T00_01 FOREIGN KEY (P06B81_DT_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;

GRANT SELECT ON P06B81T00_DOCUMENTOSTRAMITAGUN TO P06A;
GRANT SELECT ON P06B81T00_DOCUMENTOSTRAMITAGUN TO P06;

COMMENT ON COLUMN P06B81T00_DOCUMENTOSTRAMITAGUN.P06B81_DT_NUMEXP IS 'Numero de expediente';
COMMENT ON COLUMN P06B81T00_DOCUMENTOSTRAMITAGUN.P06B81_DT_ROLEIDPIDFICHERO IS 'RoleID documento en PID';
COMMENT ON COLUMN P06B81T00_DOCUMENTOSTRAMITAGUN.P06B81_DT_CODPIDFICHERO IS 'Referencia documento en PID';
COMMENT ON COLUMN P06B81T00_DOCUMENTOSTRAMITAGUN.P06B81_DT_NOMBREFICHERO IS 'Nombre del documento en PID';
COMMENT ON COLUMN P06B81T00_DOCUMENTOSTRAMITAGUN.P06B81_DT_EXTENSIONFICHERO IS 'Extension del documento en PID';


--------------------------------------------------------------------------------------------
--  Nueva tabla Codigos de ficheros adjuntados en la modificacin presentada en Tramitagune.
--------------------------------------------------------------------------------------------
CREATE TABLE P06B82T00_DOCUMENTOSMODTRAMITA
(
	P06B82_DM_CORRELATENCPETIC	NUMBER(7) NOT NULL,
	P06B82_DM_ROLEIDPIDFICHERO	VARCHAR2(200) NOT NULL,
	P06B82_DM_CODPIDFICHERO		VARCHAR2(200) NOT NULL,
	P06B82_DM_NOMBREFICHERO		VARCHAR2(260) NOT NULL,
	P06B82_DM_EXTENSIONFICHERO  VARCHAR2(5)
)
TABLESPACE P0601E00;

CREATE SYNONYM P06B82S00 FOR P06B82T00_DOCUMENTOSMODTRAMITA;

ALTER TABLE P06B82T00_DOCUMENTOSMODTRAMITA ADD CONSTRAINT P06B82I00 PRIMARY KEY
	(P06B82_DM_CORRELATENCPETIC, P06B82_DM_CODPIDFICHERO) USING INDEX TABLESPACE P0602E00;
	
ALTER TABLE P06B82T00_DOCUMENTOSMODTRAMITA ADD CONSTRAINT FK_P06B82T00_01 FOREIGN KEY (P06B82_DM_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

GRANT SELECT ON P06B82T00_DOCUMENTOSMODTRAMITA TO P06A;
GRANT SELECT ON P06B82T00_DOCUMENTOSMODTRAMITA TO P06;

COMMENT ON COLUMN P06B82T00_DOCUMENTOSMODTRAMITA.P06B82_DM_CORRELATENCPETIC IS 'Numero de expediente';
COMMENT ON COLUMN P06B82T00_DOCUMENTOSMODTRAMITA.P06B82_DM_ROLEIDPIDFICHERO IS 'RoleID documento en PID';
COMMENT ON COLUMN P06B82T00_DOCUMENTOSMODTRAMITA.P06B82_DM_CODPIDFICHERO IS 'Referencia documento en PID';
COMMENT ON COLUMN P06B82T00_DOCUMENTOSMODTRAMITA.P06B82_DM_NOMBREFICHERO IS 'Nombre del documento en PID';
COMMENT ON COLUMN P06B82T00_DOCUMENTOSMODTRAMITA.P06B82_DM_EXTENSIONFICHERO IS 'Extension del documento en PID';

DELETE FROM P06B70T00_CORREDORES
WHERE P06B70_CO_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

DELETE FROM P06B71T00_ENT_VINCULADAS
WHERE P06B71_EV_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

DELETE FROM P06B72T00_SOCIOSEXP
WHERE P06B72_SC_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

DELETE FROM P06B74T00_ORGANOSDIREXP
WHERE P06B74_OD_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

DELETE FROM P06B76T00_ATENCLIENTE
WHERE P06B76_AC_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

DELETE FROM P06B79T00_DEFECLIENTE
WHERE P06B79_DC_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

DELETE FROM P06B80T00_CAPACIDADFINANCIERA
WHERE P06B80_CF_CORRELATENCPETIC NOT IN (SELECT DISTINCT P06B64_AP_CORRELATENCPETIC FROM P06B64T00_ATENDERPETICION);

ALTER TABLE P06B70T00_CORREDORES ADD CONSTRAINT FK_P06B70T00_01 FOREIGN KEY (P06B70_CO_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

ALTER TABLE P06B71T00_ENT_VINCULADAS ADD CONSTRAINT FK_P06B71T00_01 FOREIGN KEY (P06B71_EV_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

ALTER TABLE P06B72T00_SOCIOSEXP ADD CONSTRAINT FK_P06B72T00_01 FOREIGN KEY (P06B72_SC_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

ALTER TABLE P06B74T00_ORGANOSDIREXP ADD CONSTRAINT FK_P06B74T00_01 FOREIGN KEY (P06B74_OD_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

ALTER TABLE P06B76T00_ATENCLIENTE ADD CONSTRAINT FK_P06B76T00_01 FOREIGN KEY (P06B76_AC_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

ALTER TABLE P06B79T00_DEFECLIENTE ADD CONSTRAINT FK_P06B79T00_01 FOREIGN KEY (P06B79_DC_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;

ALTER TABLE P06B80T00_CAPACIDADFINANCIERA ADD CONSTRAINT FK_P06B80T00_01 FOREIGN KEY (P06B80_CF_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC) ON DELETE CASCADE;




DELETE FROM P06B22T00_SOCIOSEXP
WHERE P06B22_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B24T00_ORGANOSDIREXP
WHERE P06B24_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B25T00_SUCURSALES
WHERE P06B25_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B27T00_ATENCLIENTEPER
WHERE P06B27_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B28T00_ATENCLIENTERES
WHERE P06B28_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B30T00_DEFECLIENTECON
WHERE P06B30_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B31T00_DOCUMENTOS
WHERE P06B31_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B60T00_CAPACIDADFINANCIERA
WHERE P06B60_CF_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

DELETE FROM P06B61T00_ENT_VINCULADAS
WHERE P06B61_EV_NUMEXP NOT IN (SELECT DISTINCT P06B20_NUMEXP FROM P06B20T00_CORREDORES);

ALTER TABLE P06B22T00_SOCIOSEXP ADD CONSTRAINT FK_P06B22T00_01 FOREIGN KEY (P06B22_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;

ALTER TABLE P06B24T00_ORGANOSDIREXP ADD CONSTRAINT FK_P06B24T00_01 FOREIGN KEY (P06B24_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B25T00_SUCURSALES ADD CONSTRAINT FK_P06B25T00_01 FOREIGN KEY (P06B25_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;

ALTER TABLE P06B27T00_ATENCLIENTEPER ADD CONSTRAINT FK_P06B27T00_01 FOREIGN KEY (P06B27_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B28T00_ATENCLIENTERES ADD CONSTRAINT FK_P06B28T00_01 FOREIGN KEY (P06B28_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B30T00_DEFECLIENTECON ADD CONSTRAINT FK_P06B30T00_01 FOREIGN KEY (P06B30_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B31T00_DOCUMENTOS ADD CONSTRAINT FK_P06B31T00_01 FOREIGN KEY (P06B31_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B60T00_CAPACIDADFINANCIERA ADD CONSTRAINT FK_P06B60T00_01 FOREIGN KEY (P06B60_CF_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B61T00_ENT_VINCULADAS ADD CONSTRAINT FK_P06B61T00_01 FOREIGN KEY (P06B61_EV_NUMEXP)
	  REFERENCES P06B20T00_CORREDORES (P06B20_NUMEXP) ON DELETE CASCADE;
	  
ALTER TABLE P06B24T00_ORGANOSDIREXP MODIFY
   (	P06B24_IDCARGO VARCHAR2(2) NOT NULL );	  
	  
ALTER TABLE P06B34T00_DEC_MODELO02_CARGOS MODIFY
(	P06B34_IDCARGO VARCHAR2(2) NOT NULL);	  
	  
	  
	  
	  
	  
	  





	  
	  

UPDATE P06B64T00_ATENDERPETICION
SET P06B64_AP_ESTADO = 4
WHERE P06B64_AP_MENSAJEERROR IS NOT NULL OR P06B64_AP_FINALIZADA = 0;

COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_ESTADO IS 'Estado atencion peticion: Recogida(0), Por revisar(1), Aprobada(2), Rechazada(3), Por corregir(4), Corregida(5)';

ALTER TABLE P06B64T00_ATENDERPETICION ADD(
	P06B64_AP_CONTEXTSUBMISSIONEVE	CLOB,
	P06B64_AP_EJGVDOCUMENT			CLOB);

COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_CONTEXTSUBMISSIONEVE IS 'String para parsear CONTEXTSUBMISSIONEVENT';
COMMENT ON COLUMN P06B64T00_ATENDERPETICION.P06B64_AP_EJGVDOCUMENT IS 'String para parsear EJGVDOCUMENT';

COMMIT;






ALTER TABLE P06B82T00_DOCUMENTOSMODTRAMITA ADD(
	P06B82_DM_ROLENAMECASPIDFICHER	VARCHAR2(200),
	P06B82_DM_ROLENAMEEUSPIDFICHER	VARCHAR2(200));

UPDATE P06B82T00_DOCUMENTOSMODTRAMITA SET
P06B82_DM_ROLENAMECASPIDFICHER = 'DESCONOCIDO',
P06B82_DM_ROLENAMEEUSPIDFICHER = 'EZEZAGUNA';

ALTER TABLE P06B82T00_DOCUMENTOSMODTRAMITA MODIFY(
	P06B82_DM_ROLENAMECASPIDFICHER	NOT NULL,
	P06B82_DM_ROLENAMEEUSPIDFICHER	NOT NULL);

ALTER TABLE P06B81T00_DOCUMENTOSTRAMITAGUN ADD(
	P06B81_DT_ROLENAMECASPIDFICHER	VARCHAR2(200),
	P06B81_DT_ROLENAMEEUSPIDFICHER	VARCHAR2(200));

UPDATE P06B81T00_DOCUMENTOSTRAMITAGUN SET
P06B81_DT_ROLENAMECASPIDFICHER = 'DESCONOCIDO',
P06B81_DT_ROLENAMEEUSPIDFICHER = 'EZEZAGUNA';

ALTER TABLE P06B81T00_DOCUMENTOSTRAMITAGUN MODIFY(
	P06B81_DT_ROLENAMECASPIDFICHER	NOT NULL,
	P06B81_DT_ROLENAMEEUSPIDFICHER	NOT NULL);


	
	


ALTER TABLE P06B81T00_DOCUMENTOSTRAMITAGUN ADD(
	P06B81_DT_CORRELATENCPETIC	NUMBER(7) NOT NULL);

COMMENT ON COLUMN P06B82T00_DOCUMENTOSMODTRAMITA.P06B82_DM_CORRELATENCPETIC IS 'Correlativo de atencion a peticion tramitagune';
COMMENT ON COLUMN P06B81T00_DOCUMENTOSTRAMITAGUN.P06B81_DT_CORRELATENCPETIC IS 'Correlativo de atencion a peticion tramitagune';


ALTER TABLE P06B81T00_DOCUMENTOSTRAMITAGUN ADD CONSTRAINT FK_P06B81T00_02 FOREIGN KEY (P06B81_DT_CORRELATENCPETIC)
	  REFERENCES P06B64T00_ATENDERPETICION (P06B64_AP_CORRELATENCPETIC);

exit;
